//___________________________________________________________________
//___________________________________________________________________
//  Copyright : 2021 BY HOLTEK SEMICONDUCTOR INC
//  File Name : sys_init.c
// Description: tΪlƬ{
//Targer Board: 
//   MCU      : BH67F2265
//   Author   : ming
//   Date     : 20210308
//   Version  : V00
//   History  :
//___________________________________________________________________
//___________________________________________________________________
#include "common.h"


/********************************************************************
Function: MCU_l
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void fun_ResetInit()
{
	//IO
	fun_GPIO();
#if	HARDWARE_VERSION==BHMB3006
 	fun_PGA1_INIT(Pgac1_gain1_32,16);
 	fun_PGA2_INIT();
 	fun_SCF_INIT(24);
#elif HARDWARE_VERSION==X802
 	fun_PGA1_INIT(Pgac1_gain1_32,20);
 	fun_PGA2_INIT();
 	fun_SCF_INIT(24);
 #elif HARDWARE_VERSION==B02
 	fun_PGA1_INIT(Pgac1_gain1_32,16);
 	fun_PGA2_INIT();
 	fun_SCF_INIT(24);
#endif		

 	fun_CCurrent_INIT();
	fun_En_Analog_power();
	fun_Enable_ADC();
 	//ptm2
 	//SETPTM2_10MS();
 	//SETCTM0_1MS_ISR();
 	SETCTM0_10MS();
 	_ct0on  = 1;	
 	
 	//TimeBase 
 	_tb0c = TimeBase0_Default;
 	_tb1c = TimeBase1_Default;
 	_pscr = 0x03;//	time base click = fsub
	_tb1on = 1;
	
	_stmc0 = STM0C0_Default;
	_stmc1 = STM0C1_Default;
	_stmal = STM0AL_Default;//;eŤ
	_stmah = STM0AH_Default;
	_stmrp = STM0RP_Default;//4*256 P	

	
  	GCC_NOP();
	
	fun_en_battery_check();
	gbv_bat_low = 0;
	gu8v_battery_votage = 0;
	_emi  = 1;	//}TimeBase 1@˴
	
	
	
	
}
/********************************************************************
Function: MCUWql
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void fun_PowerOnInit()
{
	//LVR
	SETLVR_Voltage2_1();
	//IAP not need	to init
	//EEPROM not need to init
	//RAM
	fun_RamInit();
   	SETHIRC_8MHZ();
  	SETLXT_32768(); 
	//WDT
	SETWDTtime8192ms();
	//LVR
	SETLVR_Voltage2_1();
	//IO
	fun_ResetInit();
	 	Uart_Init();
	fun_CAL_REEPROM();
	fun_init_time();	
}
/********************************************************************
Function: UӼҶiJHLATҦ
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void fun_PrepareToHalt()
{
	gu8v_err_code = 0;	
	gu8v_filter_guide = 0;
	gbv_pressure_lock = 0;
	gu16v_pressure_max = 0;
	gu16v_pressure_min = 300;
	gu8v_unit_setting_time = 0;
	fun_dis_battery_check();	
	fun_Disable_ADC();	
	fun_Dis_Analog_power();
	fun_LCD_Disable();
//	LCD_ICON(LBC_CLR,LCD_mmhg_ADDR);
//	LCD_DISP_DIA_ON(LBC_CLR,gu16v_dia,0);
//	LCD_DISP_SYS_ON(LBC_CLR,gu16v_sys,0);	
//	LCD_DISP_Pluse_ON(LBC_CLR,gu8v_heart);	
	_ct0on  = 0;
	gbv_tb1_flag = 0;
	_regc = 0x00;
	_fsiden = 1;
	GCC_HALT();
	fun_500ms_polling();	 
	if(gbv_tb1_flag)
	{
		
	}
	else
	{
	 	fun_ResetInit();
		fun_LCD_INIT();
		fun_LCD_Enable();		
		gu8v_halt_time = LU8C_HALT_TIME - 8;
	}
}


//HALT
//SLEEPMode0	@(IDLEN==0  & LVDEN==Disable & WDT Disable )
//Stop:CPU,Fsub,Fs,Disable WDT,LVDEN must Disable

//SLEEPMode1	@(IDLEN==0  & (LVDEN==Disable || WDT Disable) )
//Stop:CPU,Fsub,Fs,
//Run :Enable WDT or LVDEN

//IDLEMode0		@(IDLEN==1  & FSYSON==0 )
//Stop:CPU,Fs
//Run :Fsub

//IDLEMode1		@(IDLEN==1  & FSYSON==1 )
//Stop:CPU
//Run :Fs,Fsub



/********************************************************************
Function: GPIOl
INPUT	: none
OUTPUT	: none
NOTE	: ҦIO configXlow
********************************************************************/
void fun_GPIO()
{
	_pac =  0b11100111;
	_papu = 0b11100010;	
	_pa = 0;
	_pbc = 0b10011111;
	_pbpu =   0b10011111;		
	_pb =0;
	_pcc = 	0b11110011;
	_pcpu = 0b11110011;		
	_pc = 	0b00000000;
	_pdc = 0;
	_pdpu = 0;		
	_pd = 0;
//	_pec = 0;
//	_pepu = 0;	
//	_pe = 0;
//	_pfc = 0;	
//	_pfpu = 0;	
//	_pf = 0;	
//	_pgc = 0b00010110;	
//	_pgpu = 0b00010110;	
//	_pg = 0b00010110;		
	
	fun_Key_init();
	SET_VALUE_OFF();
	SET_PUMP_OFF();	
	





}
/********************************************************************
Function:Ram_Init
INPUT	:
OUTPUT	:
NOTE	:BH67F2265 
********************************************************************/
void fun_RamInit()
{
	_mp1h = 0;
	_mp1l = 0x80;
	while(_mp1h<RamBankSectorSum)
	{
		for(_tblp = 0x00;_tblp < 128;_tblp++)
		{
			 _iar1 = 0;
			  _mp1l++;
		}
		_mp1l = 0x80;		
		_mp1h++;	
		
	}		
}

